#include "VOS_API/DX_VOS_Time.h"
#include "VOS_API/DX_VOS_Stdio.h"

DxStatus DX_VOS_GetTimeStamp(DxChar* timeStamp, DxUint32 timeStampSize)
{
    DX_DECLARE(DxStatus, result, DX_SUCCESS);
    DxTimeStruct_t timeStampStruct;

    result = DX_VOS_GetLocalTime(DX_VOS_GetTime(), &timeStampStruct);
    if (result != DX_SUCCESS)
        RETURN_OLD_ERROR(result);

    result = DX_VOS_SPrintf(timeStamp, timeStampSize, "%04d%02d%02d_%02d%02d%02d_%08X", 
        timeStampStruct.tm_year, timeStampStruct.tm_mon, timeStampStruct.tm_mday,
        timeStampStruct.tm_hour, timeStampStruct.tm_min, timeStampStruct.tm_sec, DX_VOS_GetTickCount());
    if (result != DX_SUCCESS)
        RETURN_OLD_ERROR(result);
    DX_RETURN(DX_SUCCESS);
   
}

